// ProgCtrl.cpp : implementation file
//

#include "stdafx.h"
#include "ctrldemo.h"
#include "ProgCtrl.h"

#ifdef _DEBUG
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif

/////////////////////////////////////////////////////////////////////////////
// CProgCtrlPage property page

IMPLEMENT_DYNCREATE(CProgCtrlPage, CPropertyPage)

#ifdef _DEBUG
#define new DEBUG_NEW
#endif

CProgCtrlPage::CProgCtrlPage() : CPropertyPage(CProgCtrlPage::IDD)
{
	//{{AFX_DATA_INIT(CProgCtrlPage)
	m_uiStep = 10;
	m_uiRangeFrom = 0;
	m_uiPos = 0;
	m_uiRangeTo = 100;
	//}}AFX_DATA_INIT
}

CProgCtrlPage::~CProgCtrlPage()
{
}

void CProgCtrlPage::DoDataExchange(CDataExchange* pDX)
{
	CPropertyPage::DoDataExchange(pDX);
	//{{AFX_DATA_MAP(CProgCtrlPage)
	DDX_Control(pDX, IDC_PROGRESS, m_Progress);
	DDX_Text(pDX, IDC_PROGRESS_STEP, m_uiStep);
	DDV_MinMaxUInt(pDX, m_uiStep, 0, 65535);
	DDX_Text(pDX, IDC_PROGRESS_FROM, m_uiRangeFrom);
	DDV_MinMaxUInt(pDX, m_uiRangeFrom, 0, 65535);
	DDX_Text(pDX, IDC_PROGRESS_TO, m_uiRangeTo);
	DDV_MinMaxUInt(pDX, m_uiRangeTo, 0, 65535);
	DDX_Text(pDX, IDC_PROGRESS_POS, m_uiPos);
	DDV_MinMaxUInt(pDX, m_uiPos, 0, 65535);
	//}}AFX_DATA_MAP
}

BOOL CProgCtrlPage::OnInitDialog()
{
	CPropertyPage::OnInitDialog();
	m_Progress.SetRange( m_uiRangeFrom, m_uiRangeTo );
	m_Progress.SetPos( m_uiPos );
	return TRUE;
}

BEGIN_MESSAGE_MAP(CProgCtrlPage, CPropertyPage)
	//{{AFX_MSG_MAP(CProgCtrlPage)
	ON_BN_CLICKED(IDC_PROGRESS_STEPIT, OnProgressStepit)
	ON_EN_KILLFOCUS(IDC_PROGRESS_FROM, OnFrom)
	ON_EN_KILLFOCUS(IDC_PROGRESS_TO, OnTo)
	ON_EN_KILLFOCUS(IDC_PROGRESS_STEP, OnStep)
	ON_BN_CLICKED(IDC_SETPOS, OnSetpos)
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()

/////////////////////////////////////////////////////////////////////////////
// CProgCtrlPage message handlers

void CProgCtrlPage::OnProgressStepit() 
{
	UINT uPrev = m_Progress.StepIt();
#if (_WIN32_WCE >= 201)
	m_uiPos = m_Progress.GetPos();
	UpdateData(FALSE);
#endif // _WIN32_WCE >= 201
}

void CProgCtrlPage::OnFrom() 
{
	UpdateData();
	if (m_uiRangeFrom > m_uiRangeTo) {
		SWAP(m_uiRangeFrom, m_uiRangeTo);
		UpdateData(FALSE);
	}
	m_Progress.SetRange( m_uiRangeFrom, m_uiRangeTo );
	
	if (m_uiPos < m_uiRangeFrom) 
	{
		m_uiPos = m_uiRangeFrom;
		UpdateData(FALSE);
	}
}

void CProgCtrlPage::OnTo() 
{
	UpdateData();
	if (m_uiRangeFrom > m_uiRangeTo) {
		SWAP(m_uiRangeFrom, m_uiRangeTo);
		UpdateData(FALSE);
	}
	m_Progress.SetRange( m_uiRangeFrom, m_uiRangeTo );

	if (m_uiPos > m_uiRangeTo) 
	{
		m_uiPos = m_uiRangeTo;
		UpdateData(FALSE);
	}
}

void CProgCtrlPage::OnStep() 
{
	UpdateData();
	m_Progress.SetStep( m_uiStep );
}

void CProgCtrlPage::OnSetpos() 
{
	UpdateData();
	if (m_uiPos < m_uiRangeFrom || m_uiPos > m_uiRangeTo) {
		m_uiPos = m_uiRangeFrom;
		UpdateData(FALSE);
	}
	m_Progress.SetPos( m_uiPos );
}
